param (
    [string]$PrinterName
)

try {
    # Druckername fuer Schwarz-Weiß und Farbe generieren
    $PrinterNameSW = "$PrinterName (SW)"
    $PrinterNameColor = "$PrinterName (Farbe)"

    Write-Host "Setze Standard-Druckeinstellungen fuer: $PrinterNameSW ..."
    
    # Setze den Druckmodus fuer Schwarz-Weiß auf Monochrome
    Set-PrintConfiguration -PrinterName $PrinterNameSW -Color $false

    # Duplex fuer Schwarz-Weiß deaktivieren
    Set-PrintConfiguration -PrinterName $PrinterNameSW -DuplexingMode OneSided

    Write-Host "Setze Standard-Druckeinstellungen fuer: $PrinterNameColor ..."

    # Duplex fuer Farbe deaktivieren
    Set-PrintConfiguration -PrinterName $PrinterNameColor -DuplexingMode OneSided

    Write-Host "Fertig! Alle Einstellungen wurden erfolgreich gesetzt."
}
catch {
    Write-Host "Fehler: Konnte die Druckereinstellung nicht ändern. ueberpruefe, ob die Drucker '$PrinterNameSW' und '$PrinterNameColor' existieren!"
}
